//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

mat3 getMoonRotMatrix(vec3 usunvec)
{
    usunvec = normalize(usunvec);
    vec3 uupvec = normalize(vec3(0.0,1.0,0.0));

    vec3 avgvec = normalize(uupvec-usunvec);

    vec4 quat = normalize(vec4(cross(uupvec,avgvec),dot(uupvec,avgvec)));

    mat3 rotMatrix = mat3(1.0);
    rotMatrix[0][0] = 1.0 - 2 * quat.y * quat.y - 2 * quat.z * quat.z;
    rotMatrix[1][0] = 2 * quat.x * quat.y + 2 * quat.z * quat.w;
    rotMatrix[2][0] = 2 * quat.x * quat.z + 2 * quat.y * quat.w;

    rotMatrix[0][1] = 2 * quat.x * quat.y - 2 * quat.z * quat.w;
    rotMatrix[1][1] = 1.0 - 2 * quat.x * quat.x - 2 * quat.z * quat.z;
    rotMatrix[2][1] = 2 * quat.y * quat.z + 2 * quat.x * quat.w;

    rotMatrix[0][2] = 2 * quat.x * quat.z + 2 * quat.y * quat.w;
    rotMatrix[1][2] = 2 * quat.y * quat.z - 2 * quat.x * quat.w;
    rotMatrix[2][2] = 1.0 - 2 * quat.x * quat.x - 2 * quat.y * quat.y;

    return rotMatrix;
}